#!/usr/bin/php
<?php
// Edit this
$basedir = "/var/lib/xmail";
$logdir = "$basedir/logs";
$domaindir = "$basedir/domains";
$spooldir = "$basedir/spool";

$secret = $defaultsecret = "ztx450";
$language = 'GE';

$ignorelist = array("/From:.*postmaster[\w\-\.]*@[\w\-]+\.[\w\-]+/i", 
				"/From:.*MAILER[\w\-\.]*@[\w\-]+\.[\w\-]+/i");

//*** EDIT NOTHING BELOW THIS LINE ***
$file = $argv[1];
$from = $argv[2];
$rcpt = $argv[3];
$rej_file = $file.".rej";
$log_file = "$logdir/autoreply_".date("Ymd").".log";

$doreply = TRUE;


if (eregi('([a-z0-9\-_\.]*)@([a-z0-9\-_\.]*)', $rcpt, $userinfo))
{
	$replyfile = "$domaindir/" . $userinfo[2] . "/" . $userinfo[1] . "/auto"; 
	$rejectfile = $replyfile . ".reject";
	$secretfile = $replyfile . ".secret";
	$filterfile = $replyfile . ".filter";
	$replyfile .= ".reply";
	
	if (file_exists($rejectfile)) $filtermode = "reject";
	else $filtermode = "reply";
	
	$handle = fopen($file, "r");
	
	while (!feof($handle)) 
	{
		$line = fgets($handle);
		
		if (!strlen(trim($line))) break;
		
		
		foreach ($ignorelist as $ignore)
		{
			if (preg_match($ignore, $line)) 
			{
				$doreply = FALSE;
				break;
			}
		}
		
		if (preg_match("/X-Autoreply:\s*TRUE/i", $line)) $doreply = FALSE;

		if (preg_match("/(Content-Type:\s+[\w+\/\-\.]*;)/i", $line, $result)) 
		{
			$contenttype = $result[1];
		}
		
		if (preg_match("/(\s+boundary=\".*\")/i", $line, $result)) 
		{
			$boundary = $result[1];
		}
		
		if (eregi('^Subject:[[:blank:]]*xmailcmd[\!:][[:blank:]]*([a-z]*)[[:blank:]]*([\.a-z0-9@_\-]*)', $line, $result))
		{
			if (file_exists($secretfile)) 
			{
				$secretcontent = file ($secretfile);
				$secret = trim($secretcontent[0]);
			}
			
			$logstr = "from:$from to:$rcpt -> $result[1], $result[2]";
						
			if ($result[2] == $secret) 
			{
				if (($defaultsecret == $secret) && ($rcpt != $from))
				{
					$logstr .= " => default secret not valid if 'from' is not equal to 'to'";
					$secretvalid = FALSE;
					switch ($language)
					{
					case 'GE':
						$reply =
							"Das Standard-Geheimwort kann nicht verwendet werden, wenn Absender und Empfnger\n".
							"nicht identisch sind, also eine Fremdadresse verwendet wird.\n".
							"Sende ein 'xmailcmd! help' als Betreff, um zu erfahren, wie ein individuelles Geheimwort\n".
							"eingerichtet werden kann.";
						break;
					default:
						$reply =
							"The default secret is not valid if 'from' is not equal to 'to'.\n".
							"Send a mail with 'xmailcmd! help' as subject for more details on how to\n".
							"set an individual secret.";
					}
					
				}
				else
				{
					$logstr .= " => secret is valid\n";
					$secretvalid = TRUE;
				}
			}
			else 
			{
				$logstr .= " => secret not valid\n";
				switch ($language)
				{
				case 'GE':
					$reply =
						"Das Geheimwort ist ungltig.";
					break;
				default:
					$reply =
						"The secret is invalid.";
				}
				$secretvalid = FALSE;
			}
			
			writelog($logstr);	
			
//			if ($result[2] != $secret) break;

			switch ($result[1])
			{
			case 'reject':
				if ($secretvalid)
				{
					$fillfile = $rejectfile;
					
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Eine Abweisungs-Meldung fr den Benutzer '$rcpt' wurde erstellt.";
						break;
					default:
						$reply = 
							"A reject message has been created for user '$rcpt'.";
					}
				}
				break;
			case 'reply':
				if ($secretvalid)
				{
					$fillfile = $replyfile;

					switch ($language)
					{
					case 'GE':
						$reply = 
							"Eine automatische Antwort fr den Benutzer '$rcpt' wurde eingerichtet.";
						break;
					default:
						$reply = 
							"A autoreply message has been created for user '$rcpt'.";
					}
				}
				break;
			case 'replyoff':
				if ($secretvalid)
				{
					unlink($replyfile); 
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Die automatische Antwort fr den Benutzer '$rcpt' wurde aufgehoben.";
						break;
					default:
						$reply = 
							"The autoreply message for user '$rcpt' has been canceled.";
					}
				}	
				break;
			case 'rejectoff':
				if ($secretvalid)
				{
					unlink($rejectfile); 
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Die Abweisungs-Meldung fr den Benutzer '$rcpt' wurde aufgehoben.";
						break;
					default:
						$reply = 
							"The reject message for user '$rcpt' has been canceled.";
					}
				}
				break;
			case 'secret':
				if ($secretvalid)
				{
					while (!feof($handle))
					{
						$line = fgets($handle);
	
						if (preg_match("/(Content-Type:\s+[\w+\/\-\.]*;)/i", $line, $result))
						{
							$contenttype = $result[1];
						}
	
						if (preg_match("/(\s+boundary=\".*\")/i", $line, $result))
						{
							$boundary = $result[1];
						}
	
						if (!strlen(trim($line))) break;
					}
	
					$success = FALSE;
					
					if (!feof($handle))
					{
						if (isset($contenttype) && ($contenttype != "Content-Type: text/plain;"))
						{
							switch ($language)
							{
							case 'GE':
								$reply =
									"Das Geheimwort kann nur aus einer reinen Text-Mail ('text/plain') gesetzt werden.\n".
									"Empfangen wurde ein Typ '$contenttype'.";
								break;
							default:
								$reply =
									"The secret can only be extracted from a plain text mail ('text/plain').\n".
									"The received mail is a '$contenttype'.";
							}
						}
						else
						{
							while (!feof($handle))
							{
								$line = trim(fgets($handle));
								
								if (strlen($line) >= 6) 
								{
									file_put_contents($secretfile, $line);
									$success = TRUE;
									break;
								}
							}
						}
					}					
				
					if ($success)
					{
						switch ($language)
						{
						case 'GE':
							$reply = 
								"Das Geheimwort fr den Benutzer '$rcpt' wurde gesetzt.";
							break;
						default:
							$reply = 
								"A user secret has been set for user '$rcpt'.";
						}
					}
					else if ($reply == "")
					{
						switch ($language)
						{
						case 'GE':
							$reply =
								"Das Geheimwort fr den Benutzer '$rcpt' konnte nicht gesetzt werden. War es mindestens 6 Zeichen lang?";
							break;
						default:
							$reply =
								"The user secret for '$rcpt' could not be set. Was it 6 characters long?";
						}
					}
					
				}
				break;
			case 'secretoff':
				if ($secretvalid)
				{
					unlink($secretfile); 
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Das Geheimwort fr den Benutzer '$rcpt' wurde zurckgesetzt.";
						break;
					default:
						$reply = 
							"The user secret for user '$rcpt' has been cleared.";
					}
				}
				break;
			case 'secretsend':
				xmail(basename($file)."-secret", $rcpt, $from, "your xmail autoreply secret", $secret);
//				mail($rcpt, 
//					"your xmail autoreply secret", 
//					$secret, 
//					"From: $from\r\n" . "X-Mailer: PHP/" . phpversion());

				
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Das Geheimwort fr den Benutzer '$rcpt' wurde ihm zugestellt.";
						break;
					default:
						$reply = 
							"The user secret for user '$rcpt' has been sent to him.";
					}
				break;
			case 'filter':
				if ($secretvalid)
				{
					$fillfile = $filterfile;
				
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Das Nachrichtenfilter fr den Benutzer '$rcpt' wurde eingerichtet.";
						break;
					default:
						$reply = 
							"A message filter has been set for user '$rcpt'.";
					}
				}
				break;
			case 'filteroff':
				if ($secretvalid)
				{
					unlink($filterfile); 
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Das Nachrichtenfilter fr den Benutzer '$rcpt' wurde entfernt.";
						break;
					default:
						$reply = 
							"The message filter for user '$rcpt' has been cleared.";
					}
				}
				break;
			case 'filtersend':
				if ($secretvalid)
				{
					switch ($language)
					{
					case 'GE':
						$subject = "Ihr xmail autoreply Nachrichtenfilter";
						break;
					default:
						$subject = "your xmail autoreply message filter";
					}

					$reply = file_get_contents($filterfile);
				}
				break;
			case 'help':
			default:
			
				if (($result[1] == 'help') || ($result[1] == ''))
				{
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Kurzhilfe\n\n";
						break;
					default:
						$reply = 
							"Brief Help\n\n";
					}
				}
				else
				{
					switch ($language)
					{
					case 'GE':
						$reply = 
							"Error: unbekanntes Kommando '$result[1]'\n\n";
						break;
					default:
						$reply = 
							"Error: unrecognized command '$result[1]'\n\n";
					}
				}
					
				switch ($language)
				{
				case 'GE':
					$reply .= 
						"Gltig ist: 'xmailcmd: <Kommando> <Geheimwort>', wobei als Kommand gilt ...\n".
						"  reject:	Die Nachricht wird abgelehnt und eine Benachrichtigung geschickt.\n". 
						"  reply:	Die Nachricht wird angenommen und eine Benachrichtigung geschickt.\n". 
						"  secret:	Die erste Zeile wird als Geheimwort genommen.\n". 
						"  secretsend:	Das aktuelle Geheimwort wird dem Benutzer zugestellt\n". 
						"  filter:	Der Absender wird anhand der Filterliste ausgeschlossen.\n". 
						"  filtersend:	Die aktuelle Filterliste wird zurckgegeben.\n". 
						"  replyoff, rejectoff, secretoff and filteroff:	schaltet die Funktionen aus.\n\n". 
						"Als Meldung oder Parameter wird immer der Nachrichtentext genommen.\n\n";
					break;
				default:
					$reply .= 
						"Valid Usage: 'xmailcmd: <command> <secret>' where the command is ...\n".
						"  reject:	the message is rejected and a notification is sent.\n". 
						"  reply:	the message is accepted and automatically replied to.\n". 
						"  secret:	the first line of the message body is taken as the user secret.\n". 
						"  secretsend:	the current secret for the user is sent to him.\n". 
						"  filter:	if one of the filter list contains a part of the from:, no message is sent.\n". 
						"  filtersend:	the current filter list for the user is sent back.\n". 
						"  replyoff, rejectoff, secretoff and filteroff:	switch off the function\n\n". 
						"The message body is used as message or parameter list\n\n";
				}
			}
			
			
			if (isset($fillfile))
			{
				while (!feof($handle)) 
				{
					$line = fgets($handle);
					
					if (preg_match("/(Content-Type:\s+[\w+\/\-\.]*;)/i", $line, $result)) 
					{
						$contenttype = $result[1];
					}
					
					if (preg_match("/(\s+boundary=\".*\")/i", $line, $result)) 
					{
						$boundary = $result[1];
					}
					
					if (!strlen(trim($line))) break;
				}
				
				
				if (!feof($handle))
				{
					$fill_handle = fopen($fillfile, "w");
					
					if (isset($contenttype)) fputs($fill_handle, "$contenttype$boundary\r\n");
					fputs($fill_handle, "\r\n");
	
					while (!feof($handle)) 
					{
						$line = fgets($handle);
						fputs($fill_handle, $line);
					}
					
					fclose($fill_handle);
				}
			}
			

			if (empty($subject)) 
			{
				switch ($language)
				{
				case 'GE':
					$subject = "xmail autoreply message";
					break;
				default:
					$subject = "xmail autoreply message";
				}				
			}

			writelog("reply: $reply, to: $from");
			
			xmail(basename($file), $from, $from, $subject, $reply);

//			mail($from, 
//				$subject, 
//				$reply, 
//				"From: $from\r\n" . "X-Mailer: PHP/" . phpversion());
				
			fclose ($handle);
			exit(4);
	
		}
	}
	fclose ($handle);
	
//	if (strcasecmp($from, $rcpt)!= 0) $doreply = TRUE;
//	else $doreply = FALSE;

	if (file_exists($filterfile)) 
	{
		$filterlist = file($filterfile);
		
		foreach($filterlist as $searchstring)
		{
			if (stristr($from, trim($searchstring)) !== FALSE )
       		{
				$doreply = FALSE;
				writelog("$from found as filter string $searchstring");
				break;
			}
		}
	}
	
	if ($doreply)
	{		
		if (file_exists($rejectfile)) 
		{
			switch ($language)
			{
			case 'GE':
				$reply = "Message rejected!\n\n";
				$reply .= file_get_contents($rejectfile);
				$reply .= "\n\n-------------------------- partial original message -----------------------------\n\n";
				break;
			default:
				$reply = "E-Mail abgelehnt!\n\n";
				$reply .= file_get_contents($rejectfile);
				$reply .= "\n\n-------------------------- Ausschnitt aus der Nachricht  -----------------------------\n\n";
			}
			
			$handle = fopen($file, "r");
			
			for ($n = 0; ($n < 6) && !feof($handle); $n++)
			{
				$line = fgets($handle);
			}
			
			for ($n = 0; ($n < 200) && !feof($handle); $n++)
			{
				$reply .= fgets($handle);
			}
			
			fclose ($handle);
			
			if (!preg_match("/X-Autoreply:\s+TRUE/i", $reply) && 
				!preg_match("/From:\s+<$rcpt>/i", $reply) &&
				!preg_match("/Subject:.+xmail\s+autoreply\s+message/i", $reply))
			{
				switch ($language)
				{
				case 'GE':
					$subject = "xmail autoreject message";
					break;
				default:
					$subject = "xmail autoreject message";
				}
				
				xmail(basename($file), $from, $rcpt, $subject, $reply);
	
	//			mail($from, 
	//				$subject, 
	//				$reply, 
	//				"From: $rcpt\r\n" . "X-Mailer: PHP/" . phpversion());
			}
			else
			{
				writelog("loop detected to: $from, from: $rcpt");
			}
					
			exit(4);
		}
	   
		if (file_exists($replyfile)) 
		{
			$replyfile = file($replyfile);
			
			if (trim($replyfile[0]) > "") $header = array_shift($replyfile);
			
			$reply = implode($replyfile);
			
			switch ($language)
			{
			case 'GE':
				$subject = "xmail autoreply message";
				break;
			default:
				$subject = "xmail autoreply message";
			}

			xmail(basename($file), $from, $rcpt, $subject, $reply, $header);
//			mail($from, 
//				$subject, 
//				$reply, 
//				"From: $rcpt\r\n" . "X-Mailer: PHP/" . phpversion());
			
			exit(3);
		}
	}
	else if ($filtermode == "reject") exit(4);
}
	
exit(3);

function xmail($filename, $to = "", $from = "", $subject = "", $reply = "", $header="")
{
	global $spooldir;
	
	$file = "autoreply-$filename";
	$tempfilename = "$spooldir/temp/$file";
	$localfilename = "$spooldir/local/$file";
	
	$handle = fopen($tempfilename, "w");
	
	if ($handle)
	{
		fputs($handle, 
			"MAIL FROM: <$from>\r\n".
			"RCPT TO: <$to>\r\n".
			"\r\n".
			"From: <$from>\r\n".
			"Date: ".date("r")."\r\n".
			"To: <$to>\r\n".
			"Subject: $subject\r\n".
			"X-Mailer: PHP/".phpversion()."\r\n".
			"X-Autoreply: TRUE\r\n".
			$header.
			"\r\n".
			"$reply\r\n\r\n");
		
		fclose($handle);
		
		copy($tempfilename, "/tmp/test.hapi");
		rename($tempfilename, $localfilename);
	}
}


function writelog($str)
{
	global $log_file;

	file_put_contents($log_file, date("Y-m-d H:i:s").": $str\n", FILE_APPEND);
}
?>