#!/usr/bin/php
<?php
// stuffed together May - July 2013 by Martin Schmid, APS systems AG
// this has been written for win32 and may need some looking through for unix systems


// Edit this
$basedir = "/var/lib/xmail";

$logdir = "$basedir/logs";
$domaindir = "$basedir/domains";
$spooldir = "$basedir/spool";


//*** EDIT NOTHING BELOW THIS LINE ***
$file = $argv[1];
$rfrom = $from = $argv[2];
$rrcpt = $argv[3];
$rcpt = $argv[4];

$exitcode = 0;

$log_file = "$logdir/listhandler_".date("Ymd").".log";


preg_match('/([a-z0-9\-_\.]*)\@([a-z0-9\-_\.]*)/i', $rrcpt, $info2);

$localdomain = $info2[2];

$loopdetect = FALSE;

if (preg_match('/([a-z0-9\-_\.]*)\-(subscribe|unsubscribe)@([a-z0-9\-_\.]*)/i', $rcpt, $info))
{
	if ($rfrom == $rcpt)
	{
		$exitcode = 4;
		writelog("fake mail: $rfrom tried to send to $rcpt!");
	
		exit($exitcode);
	}

	$job = $info[2];
	$listname = $info[1];

	$listbasedir = "$domaindir/$localdomain/$listname/"; 
	$memberfile = $listbasedir . "mlusers.tab";
	
	$pendingdir = "$basedir/listhandler/pending/";
	@mkdir($pendingdir, 0744, TRUE);
		
	writelog("from:$from to:$rcpt ($rrcpt)");

	$handle = fopen($file, "r");
	
	$committed = false;
	
	while (!feof($handle)) 
	{
		$line = fgets($handle);

		if (preg_match("/X-Listhandler:\s*TRUE/i", $line)) $loopdetect = TRUE;
		
		if (!strlen(trim($line))) 
		{
			for ($cont = 0; ($cont < 200) && !feof($handle); $cont++)
			{
				$line = fgets($handle);
				if (preg_match("/X-Listhandler:\s*TRUE/i", $line)) $loopdetect = TRUE;
			} 
			break;
		}
		
		if (preg_match('/^Subject:.*\s+([\w\d\.\-\+]+@[\w\d\.\-\+]+)/i', $line, $result))
		{	
			writelog("found alternative mail address in subject line for $from for list $listname: $result[1]");
			$subject_from = $result[1];
		}
		
		if (preg_match('/^Reply-To:.*\s+([\w\d\.\-\+]+@[\w\d\.\-\+]+)/i', $line, $result))
		{	
			writelog("found alternative reply-to mail address for $from for list $listname: $result[1]");
			$replyto_from = $result[1];
		}
		
		if (preg_match("/^from:.*\s+<*(\w+[\w\.\-\+]+@[^>]+)/i", $line, $result))
		{
			writelog("take 'from' mail address from header for $from for list $listname: $result[1]");
			$from = $result[1];
		}
		
		
		if (preg_match('/^Subject:.*request\s+id\s+([a-z0-9]*)/i', $line, $requestresult)) break;
	}
	
	if ($subject_from)
	{
		writelog("using mail address from subject");
		$from = $subject_from;
	}
	else if ($replyto_from)
	{
		writelog("using reply-to mail address");
		$from = $replyto_from;
	}
	
	if (isset($requestresult))
	if ($requestresult[1])
	{
		$reqpendingfile = $pendingdir.$requestresult[1].".pend";
		
		if (file_exists($reqpendingfile))
		{
			$pendingcontent = file ($reqpendingfile);
			$key = trim($pendingcontent[0]);
			$address = trim($pendingcontent[1]);
			
			writelog("got request id from $from for user $address on list $listname: $requestresult[1]");
	
			if ($key == $requestresult[1])
			{
				if ($job == "subscribe")
				{
					$mllist = file($memberfile);
					$mllistnew = array();
					foreach ($mllist as $member)
					{
						if (trim($member) && (stristr($member, '"'.$address.'"') == FALSE)) 
						{
							$mllistnew[] = trim($member);	
						}
					}
					
					$mllistnew[] = "\"$address\"\t\"R\"";
					file_put_contents($memberfile, implode("\n", array_unique($mllistnew)));
	
					$subject = "Subscription to $listname";
					
					$reply = 	"\nWillkommen bei der Mailing-Liste '$listname'!\r\n\r\n".
								"Welcome to the '$listname' mailing list!\r\n\r\n";
								
					writelog("user $address added to $listname");
					xmail(basename($file), $address, $rcpt, $subject, $reply);
				}
				else
				{
					$mllist = explode("\n", file_get_contents($memberfile));
					foreach ($mllist as &$member)
					{
						if (stristr($member, '"'.$address.'"') != FALSE)
						{
							$member = "\"$address\"\t\"X\"";
						}
					}
					
					file_put_contents($memberfile, implode("\n", array_unique($mllist)));
					
					$subject = "Unsubscription from $listname";
					
					$reply = 	"Sie haben sich von der Mailing-Liste '$listname' abgemeldet!\r\n\r\n".
								"You sucessfully unsubscribed from the '$listname' mailing list!\r\n\r\n";
					
					writelog("user $address marked disabled on $listname");
					xmail(basename($file), $address, $rcpt, $subject, $reply);						
				}
				
				$committed = true;
				unlink($reqpendingfile);
			}
		}
	}
	
	if (!$committed)
	{
		if (!$loopdetect)
		{
			$mllist = explode("\n", file_get_contents($memberfile));
			$found = FALSE;
			foreach ($mllist as $member)
			{
				if (stristr($member, '"'.$from.'"') != FALSE)
				{
					$found = TRUE;
				}
			}
		
			if ($found || ($job == 'subscribe'))
			{
				$key = md5($from.$listname);
			
				writelog("set pending status for $from for list $listname: $key");

				$pendingfile = "$pendingdir$key.pend";
				mkdir($pendingdir);
				$pendinghandle = fopen($pendingfile, "w");
				fputs($pendinghandle, "$key\n$from\n");
				fclose($pendinghandle);
				
				$subject = "$job request id $key";
				
				$reply = 	"Um den Vorgang abzuschliessen, antworten Sie bitte auf diese Nachricht, ohne an ihr etwas zu verndern.\r\n\r\n".
							"To complete the subscribe or unsubscribe process, please reply to this message without changing anything\r\n\r\n";
				
				xmail(basename($file), $from, $rcpt, $subject, $reply);		
			}
			else
			{
				writelog("user $from tried to unsubscribe from $listname but address not found!");
				
				$subject = "Problem: $job request for address $from";
				
				$reply = 	"Ihre Adresse $from befindet sich nicht in der Adressenliste der Mailing-Liste $listname. ".
							"Falls Sie unter einer anderen Mail-Adresse eingetragen sind, so senden Sie bitte nochmals eine Unsubscribe-Mail mit dieser Adresse in der Betreff-Zeile oder als Antwort-Adresse (Reply-To).\r\n\r\n".
							"Neuer Versuch: mailto:$rcpt\r\n\r\n\r\n".
							"Your address $from cannot be found among the addresses on the $listname mailing list. ".
							"If you are listed under a different mail address, please, enter this mail address into the subject line or as reply-to address and try again.\r\n\r\n".
							"Retry: mailto:$rcpt\r\n\r\n\r\n";
				
				xmail(basename($file), $from, $rcpt, $subject, $reply);		
			}
		}	
		else
		{
			writelog("loop detected on user $from");
		}
				
		$exitcode = 4;
	}
	else
	{
		unlink($pendingfile);
	}

	if (rand(0, 99) == 0)
	{
		$idfiles = glob("$pendingdir*");
		if ($idfiles !== FALSE)
		{
			$clearcount = 0;
			foreach($idfiles as $file)
			{
				if (filectime($file) < strtotime("-7 days"))
				{
					$clearcount++;
					@unlink($file);
				}
			}
	
			writelog("ID cleanup: $clearcount files deleted.");
		}
	}	


}
else
{
	if (preg_match("/(.+)@(.+)/", $rcpt, $result))
	{
		$userdir = "$domaindir/" . $result[2] . "/" . $result[1]; 

		if (file_exists("$userdir/mlusers.tab"))
		{
			$listfile = file("$userdir/user.tab");

			foreach($listfile as $line)
			{
				if (preg_match("/\"ClosedML\"\s+\"(.*)\"/", $line, $rval))
				{
					$closedml = $rval[1];
				}
			}
			
			if ($closedml)
			{
				$mlusers = file("$userdir/mlusers.tab");
				
				$exitcode = 4; // drop message
	
				foreach ($mlusers as $user)
				{
					if (stristr($user, $rfrom) && (stristr($user, '"RW"') || stristr($user, '"W"') || stristr($user, '"RA"') || stristr($user, '"A"')))
					{
						$exitcode = 0; // grant access
						break;
					}
				}
				
				if ($exitcode == 4) 
				{
					writelog("user $rfrom tried to send to $rcpt: denied!");
				}
				else
				{
					writelog("user $rfrom is allowed to send to $rcpt.");
				}
			}
			else
			{
				writelog("list $rcpt is open and user $rfrom is allowed to send.");
				
				$exitcode = 0;
			}			
		}
	}
}


exit($exitcode);	

function xmail($filename, $to = "", $from = "", $subject = "", $reply = "")
{
	global $spooldir;
	
	$file = "listhandler-$filename";
	$tempfilename = "$spooldir/temp/$file";
	$localfilename = "$spooldir/local/$file";
	
	$handle = fopen($tempfilename, "w");
	
	//writelog("send mail to $to from $from, subject: $subject");
	
	if ($handle)
	{
		fputs($handle, 
			"MAIL FROM: <$from>\r\n".
			"RCPT TO: <$to>\r\n".
			"\r\n".
			"From: <$from>\r\n".
			"Date: ".date("r")."\r\n".
			"To: <$to>\r\n".
			"Subject: $subject\r\n".
			"X-Mailer: PHP/".phpversion()."\r\n".
			"X-Listhandler: TRUE\r\n".
			"\r\n".
			$reply.
			"\r\n");
		
		fclose($handle);
		
		rename($tempfilename, $localfilename);
	}
}

function writelog($str)
{
	global $log_file;

	file_put_contents($log_file, date("Y-m-d H:i:s").": $str\n", FILE_APPEND);
}
?>
